qui {
 noisily {
	/*************************************************/
	/****** Step 1.3. Collect independence data ******/
	/*************************************************/

/*
- Independence dates: generally according to the definition of Butcher & Griffiths (2013).
*/
}		
/* 1.3.1. Load data */
cd ..		
cd ".\3. Intermediary results"
use setup, clear
merge 1:m cntrycode_BG using BG, keepusing(Start_year End_year)
drop _merge

/* 1.3.2. Destring and correct start & end years */

	destring Start_year End_year, replace

	* Correct end year of Yugoslavia
	replace End_year = 1991 if cntry == "Yugoslavia" & End_year == 2011

	* Correct start years for artificial state entry
	// Only became independent in '90s according to the BG-definition, because that is the year their population exceeds the population limit.
	// Dataset starts in 1816, so all start years before that are set to 1816
	replace Start_year = 1816 if cntry == "Andorra" & Start_year == 1993
	replace Start_year = 1866 if cntry == "Liechtenstein" & Start_year == 1990
	replace Start_year = 1861 if cntry == "Monaco" & Start_year == 1993
	replace Start_year = 1816 if cntry == "San Marino" & Start_year == 1993
	
	* Correct begin & end year for Serbia
	replace Start_year = 2006 if cntry == "ZzSerbia" & Start_year == .
	replace End_year = 2016 if cntry == "ZzSerbia" & End_year == .

	* Correct end years: no states disappeared between 2011 and 2016:
	replace End_year = 2016 if End_year == 2011

/* 1.3.3. Get data on state antiquity */

	* Add Russia as independent country after 1991 (G&B consider it the successor state of the Soviet Uion)
	preserve
	expand 2 if cntry == "Russia"
	gen helpme = _n if cntry == "Russia"
	sum helpme
	replace End_year = 1980 if helpme == `r(min)'
	replace Start_year = 1991 if helpme == `r(max)'
	gen entry_year = Start_year
	gen exit_year = End_year
	drop helpme
	
	* Make unbalaced panel: only include states while they had sovereignty
	gen helpme = _n
	rename Start_year Year_1
	rename End_year Year_2
	reshape long Year_, i(helpme) j(year)
	drop year
	rename Year_ year
	duplicates drop helpme year, force
	xtset helpme year
	tsfill
	bysort helpme (cntrycode_COW): replace cntrycode_COW = cntrycode_COW[1]
	bysort helpme (cntrycode_COW): replace entry_year = entry_year[1]
	bysort helpme (cntrycode_COW): replace exit_year = exit_year[1]
	
	* Compute state antiquity
	gen independence_years = year-entry_year
	
	* Save necessary information
	keep cntrycode_COW year independence_years
	save state_antiquity, replace
	restore
	
/* 1.3.4. Create balanced panel */
	
	* Make unbalaced panel: only include states while they had sovereignty
	gen helpme = _n
	rename Start_year Year_1
	rename End_year Year_2
	reshape long Year_, i(helpme) j(year)
	drop year
	rename Year_ year
	duplicates drop helpme year, force
	xtset helpme year
	tsfill
	bysort helpme (cntrycode_COW): replace cntrycode_COW = cntrycode_COW[1]
	drop helpme 
	
	* Finish country-identifiers
	merge m:1 cntrycode_COW using setup, keepusing(cntry* cntrycode_* region) update
	drop _merge
	merge m:m cntrycode_BG using BG, keepusing(COW_ID) update
	drop _merge
	
	* Generate new country-identifiers for all countries
	sort cntry
	egen cntrycode = group(cntry)
	order cntrycode year cntrycode_COW cntrycode_WDI COW_ID cntry
				
	* Declare panel structure
	xtset cntrycode year
				
	* Make balanced panel for synthetic control purposes
	sort cntrycode year
	xtset cntrycode year
	preserve
	duplicates drop cntrycode, force
	keep cntrycode* cntry* region*
	save identifiers, replace
	restore
	gen drop = 0
	tsfill, full
	replace drop = 1 if drop == .
				
	* Update identifiers
	merge m:1 cntrycode using identifiers, update
	drop _merge
	erase identifiers.dta
	merge m:m cntrycode_BG using BG, keepusing(COW_ID) update
	drop _merge
	
/* 1.3.5. Identify independence springs for each country */
* (eg. some countries become independent, subsequently lose independence and regain independence a second time)

	* Add data on state antiquity
	merge 1:1 cntrycode_COW year using state_antiquity, keepusing(independence_years)
	drop if _merge == 2
	drop _merge	
	
	* Keep only cases with 0 independence years after begin of dataset
	preserve
	keep cntry cntrycode year independence_years
	keep if independence_years == 0 & year != 1816
	sort cntry year
	list cntry year
				
	* Clean: drop non-secessions and unions
	drop if cntry == "Albania" & year == 1944 				// End of WWII occupation
	drop if cntry == "Austria" & year == 1955 				// End of Anschluss
	drop if cntry == "Belgium" & year == 1945 				// End of WWII occupation
	drop if cntry == "Bolivia" & year == 1840 				// Short-lived union with Peru between 1836 & 1840
	drop if cntry == "Canada" & year == 1920 				// End of WWI
	drop if cntry == "Cuba" & year == 1909 					// Brief US military occupation between 1906-1909 (named Charles Edward Magoon as governor for three years)
	drop if cntry == "Czechoslovakia" & year == 1945 		// Forced partial incorporation into Nazi Germany between 1939-1945
	drop if cntry == "Denmark" & year == 1945 				// End of WWII occupation
	drop if cntry == "Dominican Republic" & year == 1865 	// Short reversion to Spanish colony between 1863-1865 (to protect nation from Haitian annexation)
	drop if cntry == "Dominican Republic" & year == 1924 	// Brief US intervention between 1916 & 1924
	drop if cntry == "France" & year == 1944 				// End of WWII occupation
	drop if cntry == "Germany" & year == 1990 				// Union, not secession
	drop if cntry == "Greece" & year == 1944 				// End of WWII occupation
	drop if cntry == "Japan" & year == 1952 				// End of WWII occupation
	drop if cntry == "Luxembourg" & year == 1944 			// End of WWII occupation
	drop if cntry == "Netherlands" & year == 1945 			// End of WWII occupation
	drop if cntry == "Canada" & year == 1920	 			// End of WWI occupation
	drop if cntry == "Norway" & year == 1945	 			// End of WWII occupation
	drop if cntry == "Peru" & year == 1840 					// Short-lived union with Peru between 1836 & 1840
	drop if cntry == "Peru_Bolivia" & year == 1840 			// Union, not secession
	drop if cntry == "Poland" & year == 1945 				// End of WWII occupation
	drop if cntry == "Sudan" & year == 1886 				// Error? 1 declared year of independence in 1886
	drop if cntry == "Syria" & year == 1961 				// Brief union with Egypt in the United Arab Republic between 1958 & 1961
	drop if cntry == "Yemen" & year == 1990 				// Union, not secession
	drop if cntry == "Yugoslavia" & year == 1944			// End of WWII occupation
				
	* Indicate independence spring
	bysort cntry: gen independence_spring = _n
				
	* List available NICs
	sort cntry year
	list cntry year independence_spring
				
	* Save necessary data
	keep cntrycode year independence_spring
	save NICs, replace
	restore
				
	* Merge with master data
	merge 1:1 cntrycode year using NICs
	drop _merge
	erase NICs.dta
	list cntry year independence_spring if independence_spring != .
				
	* Indicate length of consecutive independence springs
	gen spring = .
	replace spring = independence_spring
	xtset cntrycode year
	replace spring = L.spring if independence_years > 0
	forval i=1/200 {
		replace spring = F.spring if independence_years < 0 & spring == .
		}

	* Calculate pre-independence years
	xtset cntrycode year
	forval i=1/200 {
		replace independence_years = F.independence_years-1 if independence_years == .
		}
		
	* Correct some remaining errors
	gen independence_years_cleaned = independence_years
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Albania" & year > 1939				// End of WWII occupation
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Austria" & year > 1938				// End of Anschluss
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Belgium" & year > 1940				// End of WWII occupation
	replace independence_years_cleaned = . if cntry == "Bolivia" & year >= 1836 & year <= 1840							// Short-lived union with Peru between 1836 & 1840
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Cuba" & year > 1906				// Brief US military occupation between 1906-1909 (named Charles Edward Magoon as governor for three years)
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Czechoslovakia" & year > 1939		// Forced partial incorporation into Nazi Germany between 1939-1945
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Denmark" & year > 1940				// End of WWII occupation
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Dominican Republic" & year > 1861	// Short reversion to Spanish colony between 1863-1865 (to protect nation from Haitian annexation)
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Dominican Republic" & year > 1916	// Brief US intervention between 1916 & 1924
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "France" & year > 1942 				// End of WWII occupation			
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Germany" & year > 1946				// Union, not secession		
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Greece" & year > 1941				// End of WWII occupation
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Japan" & year > 1945				// End of WWII occupation
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Luxembourg" & year > 1940			// End of WWII occupation
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Netherlands" & year > 1940			// End of WWII occupation
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Norway" & year > 1940				// End of WWII occupation
	replace independence_years_cleaned = . if cntry == "Peru" & year >= 1836 & year <= 1840								// Short-lived union with Bolivia between 1836 & 1840
	replace independence_years_cleaned = . if cntry == "Peru_Bolivia" & year < 1836 									// Union, not secession
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Poland" & year > 1939				// End of WWII occupation
	forval i=1/100 {
		replace independence_years_cleaned = F.independence_years_cleaned-1 if cntry == "Sudan" & year < 1887			// Error? 1 declared year of independence in 1886
		}
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Syria" & year > 1958				// End of WWII occupation
	replace independence_years_cleaned = L.independence_years_cleaned+1 if cntry == "Yugoslavia" & year > 1941			// End of WWII occupation
	replace independence_years = independence_years_cleaned
	drop independence_years_cleaned

/* 1.3.5. Generate dummy identifying all independent countries in the international system that became independent after 1940 */

gen independent = 0
replace independent = 1 if independence_years >= 0 & independence_years != . & year >= $startyear
gen independence_year = .
replace independence_year = year if independence_years == 0 & year >= $startyear
by cntrycode: egen eindependence_year = max(independence_year)
replace independence_year = eindependence_year
drop eindependence_year
replace independence_year = . if independence_year == 0

/* 1.3.6. Generate dummy identifying all (post-1940) Newly Independent Countries (NIC's) in the international system in each year */

gen independent_newly_identifier = 0												// Identify set of NIC's (countries that joined the state system post-1940)
replace independent_newly_identifier = 1 if independence_years == 0 & year >= $startyear
by cntrycode: egen eindependent_newly_identifier = max(independent_newly_identifier)
replace independent_newly_identifier = eindependent_newly_identifier
drop eindependent_newly_identifier

gen NIC = 0
replace NIC = 1 if independent_newly_identifier == 1 & independence_years >= 0 & independence_years != . // For NIC's: indicator = 0 in years pre-independence & indicator = 1 in years of and post-independence

* Label relevant variables
label var independence_year "Year of declaration of independence (the last one)"
label var independent "Dummy indicating independent countries in the state system (=1)"
label var independence_years "Years of independence, 0 = year of declaration of independence"
label var NIC "Dummy indicating newly independent countries in the state system (=1)"
label var independent_newly_identifier "Dummy identifying countries that gained independence post-1940 (=1)"
label var independence_spring "At each independence declaration, counts the number of independence declarations for this country in the sample"
label var spring "Indicates the independence spring, equal to 2 for the second independence period for a specific country in our sample"

/* 1.3.7. Generate independence dates according to COW */

* Load data
preserve
use COW_SM, clear

* Clean: drop non-secessions and unions
drop if statenme == "Albania" & independence_year_COW == 1944 				// End of WWII occupation
replace breakup_year = 2016 if statenme == "Albania" 
drop if statenme == "Austria" & independence_year_COW == 1955 				// End of Anschluss
replace breakup_year = 2016 if statenme == "Austria" 
drop if statenme == "Belgium" & independence_year_COW == 1945 				// End of WWII occupation
replace breakup_year = 2016 if statenme == "Belgium" 	
replace independence_year = 1816 if statenme == "Canada" 	
drop if statenme == "Cuba" & independence_year_COW == 1909 					// Brief US military occupation between 1906-1909 (named Charles Edward Magoon as governor for three independence_year_COWs)
replace breakup_year = 2016 if statenme == "Cuba" 
drop if statenme == "Czechoslovakia" & independence_year_COW == 1945 		// Forced partial incorporation into Nazi Germany between 1939-1945
replace breakup_year = 1992 if statenme == "Czechoslovakia" 
drop if statenme == "Denmark" & independence_year_COW == 1945 				// End of WWII occupation 
replace breakup_year = 2016 if statenme == "Denmark" 	
drop if statenme == "Dominican Republic" & independence_year_COW == 1924 	// Brief US intervention between 1916 & 1924 
replace breakup_year = 2016 if statenme == "Dominican Republic" 	
drop if statenme == "France" & independence_year_COW == 1944 				// End of WWII occupation 
replace breakup_year = 2016 if statenme == "France" 	
drop if statenme == "Germany" & independence_year_COW == 1990 				// Union, not secession 
replace breakup_year = 2016 if statenme == "Germany" 
drop if statenme == "Greece" & independence_year_COW == 1944 				// End of WWII occupation 
replace breakup_year = 2016 if statenme == "Greece"
drop if statenme == "Greece" & independence_year_COW == 1944 				// End of WWII occupation 
replace breakup_year = 2016 if statenme == "Greece"
drop if statenme == "Japan" & independence_year_COW == 1952 				// End of WWII occupation 
replace breakup_year = 2016 if statenme == "Japan"
drop if statenme == "Luxembourg" & independence_year_COW == 1944 			// End of WWII occupation 
replace breakup_year = 2016 if statenme == "Luxembourg"
drop if statenme == "Netherlands" & independence_year_COW == 1945 			// End of WWII occupation 
replace breakup_year = 2016 if statenme == "Netherlands"
drop if statenme == "Norway" & independence_year_COW == 1945	 			// End of WWII occupation 
replace breakup_year = 2016 if statenme == "Norway"
drop if statenme == "Peru" & independence_year_COW == 1840 					// Short-lived union with Peru between 1836 & 1840 
drop if statenme == "Peru_Bolivia" & independence_year_COW == 1840 			// Union, not secession 
drop if statenme == "Poland" & independence_year_COW == 1945 				// End of WWII occupation 
replace breakup_year = 2016 if statenme == "Poland"
drop if statenme == "Sudan" & independence_year_COW == 1886 				// Error? 1 declared independence in 1886 
drop if statenme == "Syria" & independence_year_COW == 1961 				// Brief union with Egypt in the United Arab Republic between 1958 & 1961 
replace breakup_year = 2016 if statenme == "Syria"
drop if statenme == "Yemen" & independence_year_COW == 1990 				// Unification, not secession 
drop if statenme == "Yugoslavia" & independence_year_COW == 1944 			// End of WWII occupation 
replace breakup_year = 1991 if statenme == "Yugoslavia"

* Indicate independence springs
sort statenme independence_year_COW
bysort statenme: gen independence_spring_COW = _n

* collect independence declaration by independence date
gen hindependence_year_1 = independence_year_COW if independence_spring_COW == 1
gen hbreakup_year_1 = breakup_year if independence_spring_COW == 1
gen hindependence_year_2 = independence_year_COW if independence_spring_COW == 2
gen hbreakup_year_2 = breakup_year if independence_spring_COW == 2
bysort cntrycode_COW_SM: egen independence_year_1 = max(hindependence_year_1)
bysort cntrycode_COW_SM: egen independence_year_2 = max(hindependence_year_2)
bysort cntrycode_COW_SM: egen breakup_year_1 = max(hbreakup_year_1)
bysort cntrycode_COW_SM: egen breakup_year_2 = max(hbreakup_year_2)
drop hind* hbreak* 

* Expand to balanced panel
gen year = 1816
replace year = 2016 if independence_spring_COW == 2
xtset cntrycode_COW_SM year
tsfill, full

* Fill missing identifiers
bysort cntrycode_COW_SM: replace statenme = statenme[1]
bysort cntrycode_COW_SM: replace cntrycode_COW_SM = cntrycode_COW_SM[1]
bysort cntrycode_COW_SM: replace independence_year_1 = independence_year_1[1]
bysort cntrycode_COW_SM: replace independence_year_2 = independence_year_2[1]
bysort cntrycode_COW_SM: replace breakup_year_1 = breakup_year_1[1]
bysort cntrycode_COW_SM: replace breakup_year_2 = breakup_year_2[1]

* Compute independence_years and independence springs according to COW
gen independence_years_COW = year - independence_year_1 if independence_year_1 <= year & breakup_year_1 >= year
replace independence_years_COW = year - independence_year_2 if independence_year_2 <= year & breakup_year_2 >= year
forval i = 1/200 {
	replace independence_years_COW = F.independence_years_COW - 1 if independence_years_COW == . 	// Compute pre-independence years
	}

* Indicate independence springs
drop independence_spring_COW
gen independence_spring_COW = 1 if independence_year_1 <= year & breakup_year_1 >= year
replace independence_spring_COW = 2 if independence_year_2 <= year & breakup_year_2 >= year
forval i=1/200 {
	replace independence_spring_COW = F.independence_spring_COW if independence_spring_COW == . // Include pre-independence period in COW independence springs, to match NICs to their mother countries in the pre-independence period
	}
	
* Keep necessary information
keep cntrycode_COW_SM year independence_years_COW independence_spring_COW statenme
save COW_independence, replace
restore

* Reroute to directory containing dofiles
cd ..
cd ".\1. Dofiles"
}
